/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Locale;
import net.mehvahdjukaar.moonlight.api.client.util.LOD;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.mehvahdjukaar.moonlight.api.client.util.TextUtil;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.client.TextUtils;
import net.mehvahdjukaar.supplementaries.client.renderers.VertexUtils;
import net.mehvahdjukaar.supplementaries.common.block.tiles.NoticeBoardBlockTile;
import net.mehvahdjukaar.supplementaries.common.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundRequestMapDataPacket;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.minecraft.class_1011;
import net.minecraft.class_1087;
import net.minecraft.class_1762;
import net.minecraft.class_1799;
import net.minecraft.class_1806;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_330;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4730;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5614;
import net.minecraft.class_746;
import net.minecraft.class_761;
import net.minecraft.class_809;
import net.minecraft.class_827;
import net.minecraft.class_918;

public class NoticeBoardBlockTileRenderer
implements class_827<NoticeBoardBlockTile> {
    private final class_918 itemRenderer;
    private final class_330 mapRenderer;
    private final class_327 font;
    private final class_4184 camera;
    private static final float PAPER_X_MARGIN = 0.1875f;
    private static final float PAPER_Y_MARGIN = 0.125f;

    public NoticeBoardBlockTileRenderer(class_5614.class_5615 context) {
        class_310 minecraft = class_310.method_1551();
        this.itemRenderer = minecraft.method_1480();
        this.mapRenderer = minecraft.field_1773.method_3194();
        this.font = context.method_32143();
        this.camera = minecraft.field_1773.method_19418();
    }

    public int getFrontLight(class_1937 world, class_2338 pos, class_2350 dir) {
        return class_761.method_23794((class_1920)world, (class_2338)pos.method_10093(dir));
    }

    public boolean getAxis(class_2350 dir) {
        return dir == class_2350.field_11043 || dir == class_2350.field_11035;
    }

    public void render(NoticeBoardBlockTile tile, float partialTicks, class_4587 matrixStackIn, class_4597 bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!tile.shouldSkipTileRenderer()) {
            class_2338 pos;
            class_1937 world = tile.method_10997();
            if (world == null) {
                return;
            }
            class_1799 stack = tile.getDisplayedItem();
            if (stack.method_7960()) {
                return;
            }
            class_2350 dir = tile.getDirection();
            float yaw = -dir.method_10144();
            class_243 cameraPos = this.camera.method_19326();
            if (LOD.isOutOfFocus((class_243)cameraPos, (class_2338)(pos = tile.method_11016()), (float)yaw)) {
                return;
            }
            int frontLight = this.getFrontLight(world, pos, dir);
            matrixStackIn.method_22903();
            matrixStackIn.method_22904(0.5, 0.5, 0.5);
            matrixStackIn.method_22907(RotHlpr.rot((int)((int)yaw)));
            matrixStackIn.method_22904(0.0, 0.0, 0.5);
            class_22 mapData = class_1806.method_8001((class_1799)stack, (class_1937)world);
            if (stack.method_7909() instanceof class_1762) {
                if (mapData != null) {
                    matrixStackIn.method_22903();
                    matrixStackIn.method_22904(0.0, 0.0, 0.008);
                    matrixStackIn.method_22905(0.0078125f, -0.0078125f, -0.0078125f);
                    matrixStackIn.method_22904(-64.0, -64.0, 0.0);
                    Integer integer = class_1806.method_8003((class_1799)stack);
                    this.mapRenderer.method_1773(matrixStackIn, bufferIn, integer.intValue(), mapData, true, frontLight);
                    matrixStackIn.method_22909();
                } else {
                    class_746 player = class_310.method_1551().field_1724;
                    NetworkHandler.CHANNEL.sendToServer((Message)new ServerBoundRequestMapDataPacket(tile.method_11016(), player.method_5667()));
                }
                matrixStackIn.method_22909();
                return;
            }
            String page = tile.getText();
            if (page != null && !page.equals("")) {
                LOD lod = new LOD(cameraPos, pos);
                if (!lod.isNearMed()) {
                    matrixStackIn.method_22909();
                    return;
                }
                matrixStackIn.method_22903();
                matrixStackIn.method_22904(0.0, 0.5, 0.008);
                float d0 = this.getAxis(dir) ? 0.56f : 0.42000002f;
                if (MiscUtils.FESTIVITY.isAprilsFool()) {
                    TextUtils.renderBeeMovie(matrixStackIn, bufferIn, frontLight, this.font, d0);
                    matrixStackIn.method_22909();
                    matrixStackIn.method_22909();
                    return;
                }
                String bookName = tile.method_5438(0).method_7964().getString().toLowerCase(Locale.ROOT);
                if (bookName.equals("credits")) {
                    TextUtils.renderCredits(matrixStackIn, bufferIn, frontLight, this.font, d0);
                    matrixStackIn.method_22909();
                    matrixStackIn.method_22909();
                    return;
                }
                int i = tile.getTextColor().method_16357();
                int r = (int)((double)class_1011.method_24033((int)i) * (double)d0);
                int g = (int)((double)class_1011.method_24034((int)i) * (double)d0);
                int b = (int)((double)class_1011.method_24035((int)i) * (double)d0);
                int i1 = class_1011.method_24031((int)0, (int)b, (int)g, (int)r);
                if (tile.needsVisualUpdate()) {
                    float paperWidth = 0.625f;
                    float paperHeight = 0.75f;
                    Pair p = TextUtil.fitLinesToBox((class_327)this.font, (class_5348)TextUtil.parseText((String)page), (float)paperWidth, (float)paperHeight);
                    tile.setFontScale(((Float)p.getSecond()).floatValue());
                    tile.setCachedPageLines((List)p.getFirst());
                }
                List<class_5481> tempPageLines = tile.getCachedPageLines();
                float scale = tile.getFontScale();
                matrixStackIn.method_22905(scale, -scale, scale);
                int numberOfLines = tempPageLines.size();
                boolean centered = ClientConfigs.Blocks.NOTICE_BOARD_CENTERED_TEXT.get();
                for (int lin = 0; lin < numberOfLines; ++lin) {
                    class_5481 str = tempPageLines.get(lin);
                    float dx = centered ? (float)(-this.font.method_30880(str)) / 2.0f + 0.5f : -0.3125f / scale;
                    float dy = (1.0f / scale - (float)(8 * numberOfLines)) / 2.0f + 0.5f;
                    if (!bookName.equals("missingno")) {
                        this.font.method_22942(str, dx, dy + (float)(8 * lin), i1, false, matrixStackIn.method_23760().method_23761(), bufferIn, false, 0, frontLight);
                        continue;
                    }
                    this.font.method_27521("\u00a7ka", dx, dy + (float)(8 * lin), i1, false, matrixStackIn.method_23760().method_23761(), bufferIn, false, 0, frontLight);
                }
                matrixStackIn.method_22909();
                matrixStackIn.method_22909();
                return;
            }
            if (!stack.method_7960() && !NoticeBoardBlockTile.isPageItem(stack.method_7909())) {
                class_4730 pattern = tile.getCachedPattern();
                if (pattern != null) {
                    class_4588 builder = pattern.method_24145(bufferIn, class_1921::method_23588);
                    int i = tile.getTextColor().method_16357();
                    float b = (float)class_1011.method_24033((int)i) / 255.0f;
                    float g = (float)class_1011.method_24034((int)i) / 255.0f;
                    float r = (float)class_1011.method_24035((int)i) / 255.0f;
                    int lu = frontLight & 0xFFFF;
                    int lv = frontLight >> 16 & 0xFFFF;
                    VertexUtils.addQuadSide(builder, matrixStackIn, -0.4375f, -0.4375f, 0.008f, 0.4375f, 0.4375f, 0.008f, 0.15625f, 0.0625f, 0.59375f, 0.9375f, r, g, b, 1.0f, lu, lv, 0.0f, 0.0f, 1.0f, pattern.method_24148());
                } else {
                    class_1087 model = this.itemRenderer.method_4019(stack, world, null, 0);
                    matrixStackIn.method_22904(0.0, 0.0, 0.015675);
                    matrixStackIn.method_22905(-0.5f, 0.5f, -0.5f);
                    this.itemRenderer.method_23179(stack, class_809.class_811.field_4319, true, matrixStackIn, bufferIn, frontLight, combinedOverlayIn, model);
                }
                matrixStackIn.method_22909();
                return;
            }
            matrixStackIn.method_22909();
        }
    }
}

